<?php
/*
Plugin Name: WPGear – Consent Privacy Policy Acceptance
Plugin URI: https://wpgear.xyz/accept-privacy-policy
Description: Accept Cookies & Privacy Policy. (Fork of "Cookie warning" by Marie Manandise, MAJWeb)
Version: 2.4.3
Text Domain: wpgear-consent-privacy-policy-acceptance
Domain Path: /languages
Author: WPGear
Author URI: https://wpgear.xyz
License: GPLv2
*/

	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly
	}
	
	include_once( __DIR__ .'/includes/functions.php' );
	include_once( __DIR__ .'/includes/admin/admin.php' );
	
	/* Init.
	----------------------------------------------------------------- */
	add_action ('init', 'WPGearCPPA_Action_init');
	function WPGearCPPA_Action_init() {
		$LocalePath = dirname (plugin_basename ( __FILE__ )) . '/languages/';	
		
		load_plugin_textdomain ('wpgear-consent-privacy-policy-acceptance', false, $LocalePath);
	}	
	
	/* Styles & Scripts.
	----------------------------------------------------------------- */	
	add_action ('wp_enqueue_scripts', 'WPGearCPPA_Action_enqueue_scripts' );	
	function WPGearCPPA_Action_enqueue_scripts () {	
		$Plugin_Url = plugin_dir_url( __FILE__ ); // со слэшем на конце	
		$Plugin_Data = get_plugin_data ( __FILE__ );
		$Plugin_Version = $Plugin_Data['Version'];		
	
		wp_enqueue_style ('wpgear-consent-privacy-policy-acceptance_style', $Plugin_Url .'style.css'); // phpcs:ignore 
		
		wp_enqueue_script ( 'jquery' );
		wp_enqueue_script ( 'wpgear-consent-privacy-policy-acceptance' , $Plugin_Url .'includes/js/wpgear-cppa.js', array('jquery'), $Plugin_Version, true );
		
		$Options = WPGearCPPA_Get_Options();
		
		$AJAX_URL =  admin_url ('admin-ajax.php');
		
		$Nonce_Key = 'WPGear – Consent Privacy Policy Acceptance';		
		$Nonce = wp_create_nonce ($Nonce_Key);
		
		$Options_JS = array(
			'messageContent' => $Options[ 'message' ],
			'okText' => $Options[ 'button_accept' ],
			'cookieName' => 'WPGearCPPA',
			'ajax_url' => $AJAX_URL,
			'nonce' => $Nonce,
		);
				 
		wp_localize_script( 'wpgear-consent-privacy-policy-acceptance' , 'wpgearcppa_user_options' , $Options_JS );
	}
	
	/* AJAX Call to Clear Cookies.
	----------------------------------------------------------------- */
	add_action('wp_ajax_wpgear-cppa_clear_cookies', 'WPGearCPPA_Action_clear_cookies');
	add_action('wp_ajax_nopriv_wpgear-cppa_clear_cookies', 'WPGearCPPA_Action_clear_cookies');
	function WPGearCPPA_Action_clear_cookies () {
		$Cookies_Request = $_REQUEST[ 'cookie' ]; // phpcs:ignore 
		$PastDate = mktime(0,0,0,1,1,1970);
		$Cookies = $_COOKIE;
		
		foreach( $Cookies as $Key => $Value ){
			if ( $Key != $Cookies_Request ) {
				setcookie( $Key , "" , $PastDate );
			}
		}
		
		echo json_encode( array( 'success' => true ) );
		
		die;
	}