<?php
/*
 * WPGear. 
 * WPGear – Consent Privacy Policy Acceptance
 * functions.php
 */
 
	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly
	}
	
	/* Get_Options / Option
	----------------------------------------------------------------- */ 	
	function WPGearCPPA_Get_Options( $Option = null ) {
		$debug_process = 'f_get_options';
		
		$Policy_Page_ID = get_option( 'wp_page_for_privacy_policy' );
		WPGearCPPA_Debugger ($Policy_Page_ID, '$Policy_Page_ID', $debug_process, __FUNCTION__, __LINE__);		
		
		$OptionPolicyPageSlug = get_post_field( 'post_name', $Policy_Page_ID );
		WPGearCPPA_Debugger ($OptionPolicyPageSlug, '$OptionPolicyPageSlug', $debug_process, __FUNCTION__, __LINE__);	
		
		$Options = get_option( "wpgear-cppa_acceptance_option", array(
			'adminonly' => 1,
			'enable' => 1,
			'clearing' => 1,
			'message' => 'By continuing to use this Site, I agree to the processing of personal data in accordance with the {Privacy Policy)',
			'button_accept' => 'I agree',
			'policypage_slug' => $OptionPolicyPageSlug,
			'policypage_text' => 'Privacy Policy',
			)
		);		
		
		$OptionAdminOnly 		= isset( $Options['adminonly'] ) ? $Options['adminonly'] : 1;
		$OptionEnable 			= isset( $Options['enable'] ) ? $Options['enable'] : 1;
		$OptionClearing 		= isset( $Options['clearing'] ) ? $Options['clearing'] : 1;
		$OptionMessage 			= isset( $Options['message'] ) ? $Options['message'] : '';
		$OptionButtonAccept		= isset( $Options['button_accept'] ) ? $Options['button_accept'] : '';
		$OptionPolicyPageSlug 	= isset( $Options['policypage_slug'] ) ? $Options['policypage_slug'] : $OptionPolicyPageSlug;
		$OptionPolicyPageText 	= isset( $Options['policypage_text'] ) ? $Options['policypage_text'] : $OptionPolicyPageSlug;
		
		$Options = array(
			'adminonly' => $OptionAdminOnly,
			'enable' => $OptionEnable,
			'clearing' => $OptionClearing,
			'message' => $OptionMessage,
			'button_accept' => $OptionButtonAccept,
			'policypage_slug' => $OptionPolicyPageSlug,
			'policypage_text' => $OptionPolicyPageText,
		);
		
		if ($Option) {
			return $Options[$Option];
		}

		WPGearCPPA_Debugger ($Options, '$Options', $debug_process, __FUNCTION__, __LINE__);
		return $Options;
	}
	
	/* Debugger. 
	----------------------------------------------------------------- */
	function WPGearCPPA_Debugger ($Content, $Subject = null, $Process = null, $Function = '', $Line = '') {
		if (function_exists( 'WPGear_Debugger' )) {
			$Source = 'WPGearCPPA';
			$Description = 'Plugin: Consent Privacy Policy Acceptance';
			
			$TimeStamp = true;
			
			$Parameters = array(
				'source' => $Source,
				'description' => $Description,
				'content' => $Content,
				'subject' => esc_html( $Subject ),
				'process' => esc_html( $Process ),
				'function' => esc_html( $Function ),
				'timestamp' => $TimeStamp,
				'line' => esc_html( $Line ),
			);
			
			WPGear_Debugger ($Parameters);
		}
	}
