<?php
/*
 * WPGear.
 * Adaptive Login Action
 * admin.php
 */

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
	
	/* Create plugin SubMenu
	----------------------------------------------------------------- */		
	add_action('admin_menu', 'AdaptiveLoginAction_Action_admin_menu');	
	function AdaptiveLoginAction_Action_admin_menu() {
		add_options_page(
			__( 'Adaptive Login Action. Options', 'adaptive-login-action' ),
			__( 'Adaptive Login Action', 'adaptive-login-action' ),
			'edit_dashboard',
			'adaptive-login-action/includes/admin/options.php',
			''
		);
	}	
	
	/* Admin Console - Styles.
	----------------------------------------------------------------- */	
	add_action ('admin_enqueue_scripts', 'AdaptiveLoginAction_Action_admin_enqueue_scripts' );
	function AdaptiveLoginAction_Action_admin_enqueue_scripts ($hook) {
		$screen = get_current_screen();
		$screen_base = $screen -> base;	

		if ($screen_base == 'adaptive-login-action/includes/admin/options') {
			global $AdaptiveLoginAction_plugin_url;			
		
			wp_enqueue_style ('adaptive-login-action_admin-style', $AdaptiveLoginAction_plugin_url .'includes/admin/admin-style.css'); // phpcs:ignore 
		}
	}
	
	/* Admin Console - Add Settings to Plugin Actions.
	----------------------------------------------------------------- */
	add_filter ('plugin_action_links_adaptive-login-action/adaptive-login-action.php', 'AdaptiveLoginAction_Filter_plugin_action_links');
	function AdaptiveLoginAction_Filter_plugin_action_links( $Links ) {
	   $debug_process = 'plugin_action_links';
	   
	   AdaptiveLoginAction_Debugger ($Links, '$Links', $debug_process, __FUNCTION__, __LINE__);
	   
	   $Links[] = '<a href="'. esc_url( get_admin_url(null, 'options-general.php?page=adaptive-login-action/includes/admin/options.php') ) .'">Settings</a>';
	   
	   return $Links;
	}