<?php
/*
 * WPGear. 
 * Adaptive Login Action
 * functions.php
 */
 
	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
	
	/* Get_Options / Option
	----------------------------------------------------------------- */ 	
	function AdaptiveLoginAction_Get_Options( $Option = null ) {
		$Options = get_option( "adaptive-login-action_option", array(
			'adminonly' => 1,
			'enable' => 1,
			'secretkey' => '',
			'zero_trust_mode' => 1,			
			'whitelist_ip' => '',
			'whitelist_ip_autoupdate' => 1,
			'restrictive_timeout_enable' => 0,
			'restrictive_timeout_limit' => 3,
			'restrictive_timeout_delay' => 5,
			'clearing' => 1,
			)
		);		
		
		$Option_AdminOnly 					= isset( $Options['adminonly'] ) ? $Options['adminonly'] : 1;
		$Option_Enable 						= isset( $Options['enable'] ) ? $Options['enable'] : 1;		
		$Option_SecretKey 					= isset( $Options['secretkey'] ) ? $Options['secretkey'] : '';
		$Option_Zero_Trust_Mode 			= isset( $Options['zero_trust_mode'] ) ? $Options['zero_trust_mode'] : 1;	
		$Option_WhiteListIP	 				= isset( $Options['whitelist_ip'] ) ? $Options['whitelist_ip'] : '';
		$Option_WhiteListAutoUpdate 		= isset( $Options['whitelist_ip_autoupdate'] ) ? $Options['whitelist_ip_autoupdate'] : 1;
		$Option_RestrictiveTimeout_Enable 	= isset( $Options['restrictive_timeout_enable'] ) ? $Options['restrictive_timeout_enable'] : 0;
		$Option_RestrictiveTimeout_Limit 	= isset( $Options['restrictive_timeout_limit'] ) ? $Options['restrictive_timeout_limit'] : 3;
		$Option_RestrictiveTimeout_Delay	= isset( $Options['restrictive_timeout_delay'] ) ? $Options['restrictive_timeout_delay'] : 5;
		$Option_Clearing 					= isset( $Options['clearing'] ) ? $Options['clearing'] : 1;

		if ($Option_WhiteListIP) {
			$Option_WhiteListIP = str_replace(",", "\r\n", $Option_WhiteListIP);
		}
		
		$Options = array(
			'adminonly' => $Option_AdminOnly,
			'enable' => $Option_Enable,
			'secretkey' => $Option_SecretKey,
			'zero_trust_mode' => $Option_Zero_Trust_Mode,
			'whitelist_ip' => $Option_WhiteListIP,
			'whitelist_ip_autoupdate' => $Option_WhiteListAutoUpdate,
			'restrictive_timeout_enable' => $Option_RestrictiveTimeout_Enable,
			'restrictive_timeout_limit' => $Option_RestrictiveTimeout_Limit,
			'restrictive_timeout_delay' => $Option_RestrictiveTimeout_Delay,
			'clearing' => $Option_Clearing,
		);
		
		if ($Option) {
			return $Options[$Option];
		}

		return $Options;
	}
 
	/* Get User IP 
	----------------------------------------------------------------- */	
	function AdaptiveLoginAction_GetUserIP () {
		$IP = null;
		
		if ( ! empty( $_SERVER['HTTP_CLIENT_IP'] )) {
			$IP = sanitize_text_field( wp_unslash( $_SERVER['HTTP_CLIENT_IP'] ) );
		} else if ( ! empty( $_SERVER['HTTP_X_FORWARDED_FOR'] )) {
			$IP = sanitize_text_field( wp_unslash( $_SERVER['HTTP_X_FORWARDED_FOR'] ) );
		} else if ( ! empty( $_SERVER['REMOTE_ADDR'] )) {
			$IP = sanitize_text_field( wp_unslash( $_SERVER['REMOTE_ADDR'] ) );
		} else {
			// Очень Странная Ситуация
		}
		
		return $IP;
	}
	
	/* Update IP-Stat (Zero Trust Mode)
	----------------------------------------------------------------- */
	function AdaptiveLoginAction_Update_LoginIP ($UserIP, $Success) {
		$debug_process = 'f_update_login-ip';
		
		$IP_Options = get_option('adaptive-login-action_ip_' .$UserIP, array());
		
		$IP_LoginTotal 		= isset($IP_Options['total']) ? $IP_Options['total'] : 0;
		$IP_LoginSuccess 	= isset($IP_Options['success']) ? $IP_Options['success'] : 0;
		$IP_Chain_Errors 	= isset($IP_Options['chain_errors']) ? $IP_Options['chain_errors'] : 0;		
		
		if ( is_null($Success) ) {
			// Reset
			$LastOK = 0;
			$IP_Chain_Errors = 0;
			
		} else {
			// Processing Success / Fail
			$IP_LoginTotal += 1;
			
			if ($Success == true) {
				$LastOK = 1;	
				$IP_LoginSuccess += 1;
				$IP_Chain_Errors = 0;
				
			} else {
				$LastOK = 0;
				$IP_Chain_Errors += 1;
			}
		}
				
		$TimeStamp = time();	
		
		$IP_Options = array (
			'last_ok' => $LastOK,
			'total' => $IP_LoginTotal,
			'success' => $IP_LoginSuccess,
			'chain_errors' => $IP_Chain_Errors,
			'timestamp' => $TimeStamp,
		);
		AdaptiveLoginAction_Debugger ($IP_Options, '$IP_Options', $debug_process, __FUNCTION__, __LINE__);
			
		update_option('adaptive-login-action_ip_' .$UserIP, $IP_Options); // phpcs:ignore 
		update_option('adaptive-login-action_last_ok', $LastOK); // phpcs:ignore 
	}
	
	/* Check Plugin Installed
	----------------------------------------------------------------- */		
	function AdaptiveLoginAction_Check_Plugin_Installed ($Plugin_Slug = null) {
		$Result = false;
		
		if ($Plugin_Slug) {
			if (! function_exists ('get_plugins')) {
				require_once ABSPATH .'wp-admin/includes/plugin.php';
			}
			
			$Plugins = get_plugins();
			
			foreach ($Plugins as $Plugin) {
				$Plugin_TextDomain = $Plugin['TextDomain'];
				if ($Plugin_TextDomain == $Plugin_Slug) {
					$Result = true;
				}
			}			
		}	
		
		return $Result;
	}
	
	/* Get User LastLoginData by ID (Dynamics IP Mode.)
	----------------------------------------------------------------- */
	function AdaptiveLoginAction_Get_UserLastLoginData_by_ID ($User_ID) {
		$debug_process = 'f_get_user_lastlogindata_by_id';
		
		AdaptiveLoginAction_Debugger ($User_ID, '$User_ID', $debug_process, __FUNCTION__, __LINE__);
		
		$UserLastLoginData = get_option( 'adaptive-login-action_user_id_' .$User_ID, array() );
		AdaptiveLoginAction_Debugger ($UserLastLoginData, '$UserLastLoginData', $debug_process, __FUNCTION__, __LINE__);
		
		return $UserLastLoginData;
	}
	
	/* Update User LastLoginData by ID (Dynamics IP Mode.)
	----------------------------------------------------------------- */
	function AdaptiveLoginAction_Update_UserLastLoginData_by_ID ($User_ID, $Success) {
		$debug_process = 'f_update_user_lastlogindata_by_id';
		
		AdaptiveLoginAction_Debugger ($User_ID, '$User_ID', $debug_process, __FUNCTION__, __LINE__);
		AdaptiveLoginAction_Debugger ($Success, '$Success', $debug_process, __FUNCTION__, __LINE__);
		
		$UserLastLoginData = get_option( 'adaptive-login-action_user_id_' .$User_ID, array() );
		AdaptiveLoginAction_Debugger ($UserLastLoginData, '$UserLastLoginData', $debug_process, __FUNCTION__, __LINE__);
		
		$User_LoginErrors = isset($UserLastLoginData['errors']) ? $UserLastLoginData['errors'] : 0;
		
		if ( is_null($Success) ) {
			// Reset
			$User_LoginErrors = 0;
			
		} else {
			// Processing Success / Fail
			if ($Success) {
				$User_LoginErrors = 0;
			} else {
				$User_LoginErrors = $User_LoginErrors + 1;
			}		
		}
				
		$User_IP = AdaptiveLoginAction_GetUserIP ();
		
		$TimeStamp = time();
		
		$UserLastLoginData['errors'] 	= $User_LoginErrors;
		$UserLastLoginData['timestamp'] = $TimeStamp;
		$UserLastLoginData['last_ip'] 	= $User_IP;
		AdaptiveLoginAction_Debugger ($UserLastLoginData, '$UserLastLoginData', $debug_process, __FUNCTION__, __LINE__);

		update_option('adaptive-login-action_user_id_' .$User_ID, $UserLastLoginData); // phpcs:ignore 
		
		return $UserLastLoginData;
	}
		
	/* Debugger. 
	----------------------------------------------------------------- */
	function AdaptiveLoginAction_Debugger ($Content, $Subject = null, $Process = null, $Function = '', $Line = '') {
		if (function_exists( 'WPGear_Debugger' )) {
			$Source = 'AdaptiveLoginAction';
			$Description = 'Plugin: Adaptive Login Action';
			
			$TimeStamp = true;
			
			$Parameters = array(
				'source' => $Source,
				'description' => $Description,
				'content' => $Content,
				'subject' => esc_html( $Subject ),
				'process' => esc_html( $Process ),
				'function' => esc_html( $Function ),
				'timestamp' => $TimeStamp,
				'line' => esc_html( $Line ),
			);
			
			WPGear_Debugger ($Parameters);
		}
	}	